/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.ByteFlags;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.LabelWidget;
import lib.toma.animations.engine.screen.animator.widget.MultiSelectListView;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AddFrameDialog
extends DialogScreen {
    private final float pos;
    private final Pattern posPattern = Pattern.compile("^(1(\\.0+)?)|(0(\\.[0-9]+))$");
    private final IInsertion insertion;
    private MultiSelectListView<AnimationStage> stageSelector;
    private TextFieldWidget position;
    private final ByteFlags errorFlags = new ByteFlags();

    public AddFrameDialog(AnimatorScreen screen, float pos, IInsertion insertionCallback) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.dialog.add_frame"), screen);
        this.pos = pos;
        this.insertion = insertionCallback;
        this.setDimensions(175, 160);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int btnWidthP = this.dWidth() - 10;
        int btnWidth = (btnWidthP - 5) / 2;
        Collection<AnimationStage> stages = Registries.ANIMATION_STAGES.values();
        this.stageSelector = (MultiSelectListView)this.func_230480_a_(new MultiSelectListView<AnimationStage>(this.field_230712_o_, this.left() + 5, this.top() + 15, btnWidthP, 75, new ArrayList<AnimationStage>(stages)));
        this.stageSelector.setFormatter(stage -> stage.getName().getString());
        this.stageSelector.setSelectionResponder(this::selection_change);
        this.func_230480_a_(new LabelWidget(this.left() + 5, this.top() + 95, btnWidthP, 15, (ITextComponent)new StringTextComponent("Position"), this.field_230712_o_));
        this.position = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 110, btnWidthP, 20, StringTextComponent.field_240750_d_));
        this.position.func_212954_a((Consumer)new SuggestionResponder("Frame position", this.position, this::pos_changed));
        this.position.func_146180_a(AnimatorScreen.POSITION_FORMAT.format(this.pos));
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 135, btnWidth, 20, CANCEL, this::cancel_clicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btnWidth, this.top() + 135, btnWidth, 20, CONFIRM, this::confirm_clicked));
        this.errorFlags.set(0);
        this.updateConfirmButtonState();
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    private void pos_changed(String value) {
        if (this.posPattern.matcher(value).matches()) {
            this.errorFlags.clear(1);
            this.position.func_146193_g(0xE0E0E0);
        } else {
            this.position.func_146193_g(0xE00000);
            this.errorFlags.set(1);
        }
        this.updateConfirmButtonState();
    }

    private void updateConfirmButtonState() {
        if (this.confirm != null) {
            this.confirm.field_230693_o_ = this.errorFlags.isEmpty();
        }
    }

    private void selection_change(AnimationStage stage, List<AnimationStage> stages) {
        if (stages.isEmpty()) {
            this.errorFlags.set(0);
        } else {
            this.errorFlags.clear(0);
        }
        this.updateConfirmButtonState();
    }

    private void confirm_clicked(Button button) {
        float progress;
        try {
            progress = Float.parseFloat(this.position.func_146179_b());
        }
        catch (NumberFormatException nfe) {
            progress = this.pos;
        }
        this.insertion.doInsertion(progress, this.stageSelector.getSelection());
        this.showParent();
    }

    public static interface IInsertion {
        public void doInsertion(float var1, List<AnimationStage> var2);
    }
}

